---
title: Delay action · Cloudflare bot solutions docs
description: Customers with a Bot Management and a Workers subscription can use
  the template below to introduce a delay to requests that are likely from bots.
lastUpdated: 2025-06-26T18:43:59.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/workers-templates/delay-action/
  md: https://developers.cloudflare.com/bots/workers-templates/delay-action/index.md
---

Customers with a Bot Management and a [Workers](https://developers.cloudflare.com/workers/) subscription can use the template below to introduce a delay to requests that are likely from bots.

The template sets a minimum and maximum delay, and delays requests where the bot score is less than 30 and the URI path starts with `/exampleURI`.

* JavaScript

  ```js
  // Configurable Variables
  const PATH_START = "/exampleURI";
  const DELAY_FROM = 5; // in seconds
  const DELAY_TO = 10; // in seconds


  export default {
    async fetch(request, env, ctx) {
      const url = new URL(request.url);
      const botScore = request.cf.botManagement.score;


      if (url.pathname.startsWith(PATH_START) && botScore < 30) {
        // Random delay between DELAY_FROM and DELAY_TO seconds
        const delay =
          Math.floor(Math.random() * (DELAY_TO - DELAY_FROM + 1)) + DELAY_FROM;
        await new Promise((resolve) => setTimeout(resolve, delay * 1000));


        // Fetch the original request
        return fetch(request);
      }


      // Fetch the original request without delay
      return fetch(request);
    },
  };
  ```

* TypeScript

  ```ts
  // Configurable Variables
  const PATH_START = '/exampleURI';
  const DELAY_FROM = 5; // in seconds
  const DELAY_TO = 10; // in seconds


  export default {
    async fetch(request, env, ctx): Promise<Response> {
      const url = new URL(request.url);
      const botScore = request.cf.botManagement.score


      if (url.pathname.startsWith(PATH_START) && botScore < 30) {
        // Random delay between DELAY_FROM and DELAY_TO seconds
        const delay = Math.floor(Math.random() * (DELAY_TO - DELAY_FROM + 1)) + DELAY_FROM;
        await new Promise(resolve => setTimeout(resolve, delay * 1000));


        // Fetch the original request
        return fetch(request);
      }


      // Fetch the original request without delay
      return fetch(request);
    },
  } satisfies ExportedHandler<Env>;
  ```
