---
title: Enhanced crawler insights and custom 402 responses · Changelog
description: Get detailed crawler analytics with trend charts and configure
  custom payment-required responses for blocked AI crawlers.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-27-ai-crawl-control-launch/
  md: https://developers.cloudflare.com/changelog/2025-08-27-ai-crawl-control-launch/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Enhanced crawler insights and custom 402 responses

Aug 27, 2025

[AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/)

We improved AI crawler management with detailed analytics and introduced custom HTTP 402 responses for blocked crawlers. AI Audit has been renamed to AI Crawl Control and is now generally available.

**Enhanced Crawlers tab:**

* View total allowed and blocked requests for each AI crawler
* Trend charts show crawler activity over your selected time range per crawler

![Updated AI Crawl Control table showing request counts and trend charts](https://developers.cloudflare.com/_astro/ai-crawl-control-table.BDr0Qd-5_Z28yWEm.webp)

**Custom block responses (paid plans):** You can now return HTTP 402 "Payment Required" responses when blocking AI crawlers, enabling direct communication with crawler operators about licensing terms.

For users on paid plans, when blocking AI crawlers you can configure:

* **Response code:** Choose between 403 Forbidden or 402 Payment Required
* **Response body:** Add a custom message with your licensing contact information

![AI Crawl Control block response configuration interface](https://developers.cloudflare.com/_astro/ai-crawl-control-block-response.L4duQj7-_ZjWQYT.webp)

Example 402 response:

```http
HTTP 402 Payment Required
Date: Mon, 24 Aug 2025 12:56:49 GMT
Content-type: application/json
Server: cloudflare
Cf-Ray: 967e8da599d0c3fa-EWR
Cf-Team: 2902f6db750000c3fa1e2ef400000001


{
  "message": "Please contact the site owner for access."
}
```
