---
title: Announcing R2 SQL · Changelog
description: Run SQL queries against Apache Iceberg tables in R2 Data Catalog
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-25-announcing-r2-sql-open-beta/
  md: https://developers.cloudflare.com/changelog/2025-09-25-announcing-r2-sql-open-beta/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Announcing R2 SQL

Sep 25, 2025

[R2 SQL](https://developers.cloudflare.com/r2-sql/)

Today, we're launching the **open beta** for [R2 SQL](https://developers.cloudflare.com/r2-sql/): A serverless, distributed query engine that can efficiently analyze petabytes of data in [Apache Iceberg](https://iceberg.apache.org/) tables managed by [R2 Data Catalog](https://developers.cloudflare.com/r2/data-catalog).

R2 SQL is ideal for exploring analytical and time-series data stored in R2, such as logs, events from [Pipelines](https://developers.cloudflare.com/pipelines/), or clickstream and user behavior data.

If you already have a table in R2 Data Catalog, running queries is as simple as:

```bash
npx wrangler r2 sql query YOUR_WAREHOUSE "
SELECT
    user_id,
    event_type,
    value
FROM events.user_events
WHERE event_type = 'CHANGELOG' or event_type = 'BLOG'
  AND __ingest_ts > '2025-09-24T00:00:00Z'
ORDER BY __ingest_ts DESC
LIMIT 100"
```

To get started with R2 SQL, check out our [getting started guide](https://developers.cloudflare.com/r2-sql/get-started/) or learn more about supported features in the [SQL reference](https://developers.cloudflare.com/r2-sql/sql-reference/). For a technical deep dive into how we built R2 SQL, read our [blog post](https://blog.cloudflare.com/r2-sql-deep-dive/).
