---
title: Better local deployment flow for Cloudflare Workers · Changelog
description: Wrangler now provides a better user experience when deploying a
  worker that was previously deployed via the Cloudflare dashboard.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-11-21-wrangler-deploy-remote-config-management/
  md: https://developers.cloudflare.com/changelog/2025-11-21-wrangler-deploy-remote-config-management/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Better local deployment flow for Cloudflare Workers

Nov 21, 2025

[Workers](https://developers.cloudflare.com/workers/)

Until now, if a Worker had been previously deployed via the [Cloudflare Dashboard](https://dash.cloudflare.com), a subsequent deployment done via the Cloudflare Workers CLI, [**Wrangler**](https://developers.cloudflare.com/workers/wrangler/) (through the [`deploy` command](https://developers.cloudflare.com/workers/wrangler/commands/#deploy)), would allow the user to override the Worker's dashboard settings without providing details on what dashboard settings would be lost.

Now instead, `wrangler deploy` presents a helpful representation of the differences between the [local configuration](https://developers.cloudflare.com/workers/wrangler/configuration/) and the remote dashboard settings, and offers to update your local configuration file for you.

See example below showing a before and after for `wrangler deploy` when a local configuration is expected to override a Worker's dashboard settings:

Before

![wrangler deploy run before the improved workflow](https://developers.cloudflare.com/_astro/before.Bz-MOePT_2ftCCl.webp)

After

![wrangler deploy run after the improved workflow](https://developers.cloudflare.com/_astro/after.BrkkBaRL_P1S4F.webp)

Also, if instead Wrangler detects that a deployment would override remote dashboard settings but in an additive way, without modifying or removing any of them, it will simply proceed with the deployment without requesting any user interaction.

Update to [Wrangler](https://developers.cloudflare.com/workers/wrangler/) v4.50.0 or greater to take advantage of this improved deploy flow.
