---
title: pfSense · Cloudflare One docs
description: This tutorial includes the steps required to configure IPsec
  tunnels to connect a pfSense firewall to Cloudflare Magic WAN.
lastUpdated: 2025-10-31T13:37:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/pfsense/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/pfsense/index.md
---

This tutorial includes the steps required to configure IPsec tunnels to connect a pfSense firewall to Cloudflare Magic WAN.

## Software tested

| Manufacturer | Firmware revision |
| - | - |
| pfSense | 24.03 |

## Prerequisites

For this tutorial, you will need to know the following information:

* Your Anycast IP addresses (given to you by Cloudflare)
* External IP addresses
* Internal IP address ranges
* Inside tunnel `/31` ranges

## Example scenario

The following IP addresses are used throughout this tutorial. Any legally routable IP addresses have been replaced with IPv4 Address Blocks Reserved for Documentation ([RFC 5737](https://datatracker.ietf.org/doc/html/rfc5737)) addresses within the `203.0.113.0/24` subnet.

| Tunnel name | `PF_TUNNEL_01` | `PF_TUNNEL_02` |
| - | - | - |
| Interface address | `10.252.2.26/31` | `10.252.2.28/31` |
| Customer endpoint | `203.0.113.254` | `203.0.113.254` |
| Cloudflare endpoint | `<YOUR_ANYCAST_IP_ADDRESS_1>` | `<YOUR_ANYCAST_IP_ADDRESS_2>` |
| Pfsense IPsec Phase 2 Local IP | `10.252.2.27` | `10.252.2.29` |
| Pfsense IPsec Phase 2 Remote IP | `10.252.2.26` | `10.252.2.28` |
| Magic WAN static routes - Prefix | `10.1.100.0/24` | `10.1.100.0/24` |
| Magic WAN static routes - Next hop | `PF_TUNNEL_01` | `PF_TUNNEL_02` |

## 1. Configure Magic WAN IPsec tunnels

Use the Cloudflare dashboard or API to [configure two IPsec tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels). The settings mentioned below are used for the IPsec tunnels referenced throughout the remainder of this guide.

### Add IPsec tunnels

1. Follow the [Add tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels) instructions to create the required IPsec tunnels with the following options:

   * **Tunnel name**: `PF_TUNNEL_01`
   * **Interface address**: `10.252.2.26/31`
   * **Customer endpoint**: `203.0.113.254`
   * **Cloudflare endpoint**: Enter the Anycast IP address provided by Cloudflare.
   * **Health check rate**: *Medium*
   * **Health check type**: *Request*
   * **Health check direction**: *Bidirectional*
   * **Turn on replay protection**: Enable

2. Select **Add pre-shared key later** > **Add tunnels**.

3. Repeat the process to create a second IPsec tunnel with the following options:

   * **Tunnel name**: `PF_TUNNEL_02`
   * **Interface address**: `10.252.2.28/31`
   * **Customer endpoint**: `203.0.113.254`
   * **Cloudflare endpoint**: Enter the Anycast IP address provided by Cloudflare.
   * **Health check rate**: *Medium*
   * **Health check type**: *Request*
   * **Health check direction**: *Bidirectional*
   * **Turn on replay protection**: Enable

4. Select **Add pre-shared key later** > **Add tunnels**.

Note

If site-to-site traffic is a requirement for your use case, you need to enable replay protection. Refer to [Add tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels) > IPsec tunnel to learn how to enable this feature.

### Generate pre-shared keys

When you create IPsec tunnels with the option **Add pre-shared key later**, the Cloudflare dashboard will show you a warning indicator.

1. Select **Edit** to edit the properties of each IPsec tunnel you have created.
2. Select **Generate a new pre-shared key** > **Update and generate pre-shared key**.
3. Copy the pre-shared key value for each of your IPsec tunnels, and save these values somewhere safe. Then, select **Done**.

Note

Take note of your pre-shared keys, and keep them in a safe place to use later in pfSense.

### IPsec identifier - User ID

After creating your IPsec tunnels, the Cloudflare dashboard will list them under **Tunnels**. To retrieve your IPsec tunnel's user ID:

1. Go to **Magic WAN** > **Configuration**.
2. Select **Tunnels**.
3. Select the IPsec tunnel.
4. Scroll to **User ID** and copy the string. For example, `ipsec@long_string_of_letters_and_numbers`.

The User ID will be required when configuring IKE Phase 1 on the pfSense firewall.

## 2. Create Magic WAN static routes

Create a [static route](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-routes/#create-a-static-route) for each of the two IPsec tunnels configured in the previous section, with the following settings (settings not mentioned here can be left with their default values):

### Tunnel 01

* **Description**: `PF_TUNNEL_01`
* **Prefix**: `10.1.100.0/24`
* **Tunnel/Next hop**: `PF_TUNNEL_01`

### Tunnel 02

* **Description**: `PF_TUNNEL_02`
* **Prefix**: `10.1.100.0/24`
* **Tunnel/Next hop**: `PF_TUNNEL_02`

## 3. Configure the pfSense firewall

Install pfSense and boot up. Then, assign and set LAN and WAN interfaces, as well as IP addresses. For example:

* **LAN**: `203.0.113.254`
* **WAN**: `<YOUR_WAN_ADDRESS>`

### Configure IPsec Phase 1

Add a new IPsec tunnel [Phase 1 entry](https://docs.netgate.com/pfsense/en/latest/vpn/ipsec/configure-p1.html), with the following settings:

* **General Information**
  * **Description**: `CF1_IPsec_P1`

* **IKE Endpoint Configuration**

  * **Key exchange version**: *IKE\_v2*
  * **Internet Protocol**: *IPv4*
  * **Interface**: *WAN*
  * **Remote gateway**: Enter your Cloudflare Anycast IP address.

* **Phase 1 Proposal (Authentication)**

  * **Authentication method**: *Mutual PSK*
  * **My identifier**: *User Fully qualified domain name* > `ipsec@long_string_of_letters_and_numbers`\
    (You can get this identifier from your Cloudflare IPsec tunnel configuration > **User ID**)
  * **Peer identifier**: *Peer IP Address* (your Cloudflare Anycast IP)
  * **Pre-Shared Key**: Enter the PSK you have on your Cloudflare IPsec tunnel.

* **Phase 1 proposal (Encryption algorithm)**

  * **Encryption algorithm**: *AES 256 bits*
  * **Key length**: *256 bits*
  * **Hash algorithm**: *SHA256*
  * **DH key group**: *20*
  * **Lifetime**: `86400`

### Configure IPsec Phase 2

Add a new IPsec tunnel [Phase 2 entry](https://docs.netgate.com/pfsense/en/latest/vpn/ipsec/configure-p2.html), with the following settings. You need to create an entry for tunnel 1 and 2, making the appropriate changes for the IP addresses for local and remote network:

* **General Information**

  * **Description**: `CF1_IPsec_P2`
  * **Mode**: *Routed (VTI)*

* **Networks**

  * **Local Network**: *Address* > Upper IP address in the `/31` assigned in Cloudflare tunnel. For example, `10.252.2.27` for tunnel 1 and `10.252.2.29` for tunnel 2.
  * **Remote Network**: *Address* > Lower IP address in the `/31` for Cloudflare side. For example, `10.252.2.26` for tunnel 1, and `10.252.2.28` for tunnel 2.

* **Phase 2 Proposal (SA/Key Exchange)**

  * **Protocol**: *ESP*
  * **Encryption algorithm**: *AES 256 bits*
  * **Hash algorithm**: *SHA256*
  * **DH key group**: *20*
  * **Lifetime**: `28800`

When you are finished, apply your changes. If you go to **Status** > **IPsec**, you should be able to check that both Phase 1 and Phase 2 are connected.

![pfSense IPsec overview](https://developers.cloudflare.com/_astro/ipsec-overview.B7tL0kto_Nzl7V.webp)

### Interface assignments

In **Interfaces** > **Assignments** > **Add**, create a new interface to assign to the first IPsec tunnel, with the following settings:

* **General configuration**

  * **Description**: `CF1_IPsec_1`
  * **MSS**: `1446`

* **Interface Assignments**

  * **WAN**: Add your WAN interface. For example, `vnet1`.
  * **LAN**: Add your LAN interface. For example, `vnet0`.
  * Add your **CF\_IPsec\_1** that you have created above for Phase 1.

Select **Save** when you are finished.

![Assign a new interface to the first IPsec tunnel](https://developers.cloudflare.com/_astro/interfaces.COkbEEZi_Z1qEfaY.webp)

![Configuring interface assignments](https://developers.cloudflare.com/_astro/interface-assignments.CblqhRKO_Zsid2F.webp)

### Gateway

In **System** > **Routing** > **Gateways** there should already be a gateway. For this example, it is named `CF1_IPSEC_1_VTIV4`.

![There should already be a gateway configured in the interface](https://developers.cloudflare.com/_astro/gateways.BWYSJrzk_2rCe1d.webp)

### Firewall Rules IPsec

1. In **Firewall Rules** > **IPsec interface**, allow any type of traffic.

![Allow all traffic for IPsec](https://developers.cloudflare.com/_astro/firewall-ipsec.CgXaJWLX_Z1pCizW.webp)

1. Navigate to **Status** > **Gateways**. `CF1_IPSEC_1_VTIV4` should now be online.

![The gateway should now be online](https://developers.cloudflare.com/_astro/status-gateways.CAqgLr_K_a1bVv.webp)

### Firewall Rules LAN

1. In **Firewall** > **Rules** > **LAN**, allow any type of traffic.
2. Expand the **Advanced** section.
3. Change the Gateway to `CF1_IPSEC_1_VTIV4`.

![Change the gateway in the firewall rules for LAN traffic](https://developers.cloudflare.com/_astro/firewall-lan.DduZnf_o_1jVj2x.webp)
