---
title: Switch between Zero Trust organizations · Cloudflare One docs
description: "In Cloudflare WARP, users can switch between multiple Zero Trust
  organizations (or other MDM parameters) that administrators specify in an MDM
  file. Common use cases include:"
lastUpdated: 2025-11-21T21:36:55.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/switch-organizations/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/switch-organizations/index.md
---

Feature availability

| [WARP modes](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) | [Zero Trust plans](https://www.cloudflare.com/teams-pricing/) |
| - | - |
| All modes | All plans |

| System | Availability | Minimum WARP version |
| - | - | - |
| Windows | ✅ | 2024.1.159.0 |
| macOS | ✅ | 2024.1.160.0 |
| Linux | ✅ | 2024.2.62.0 |
| iOS | ✅ | 1.7 |
| Android | ✅ | 1.4 |
| ChromeOS | ✅ | 1.4 |

In Cloudflare WARP, users can switch between multiple Zero Trust organizations (or other [MDM parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/)) that administrators specify in an MDM file. Common use cases include:

* Allow IT security staff to switch between test and production environments.
* Allow Managed Service Providers to support multiple customer accounts.
* Allow users to switch between the default WARP ingress IPs and the [Cloudflare China ingress IPs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/#override_warp_endpoint).

## MDM file format

To enable multiple organizations, administrators need to modify their [MDM file](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/) to take an array of configurations. Each configuration must include a `display_name` parameter that will be visible to users in the WARP client GUI. Because display names are listed in the same order as they appear in the MDM file, we recommend putting the most used configurations at the top of the file. When a user opens the WARP client for the first time, they will be prompted to log into the first configuration in the list.

An MDM file supports a maximum of 25 configurations. The following example includes three configurations.

### XML

```xml
<dict>
  <key>configs</key>
  <array>
    <dict>
      <key>organization</key>
      <string>mycompany</string>
      <key>display_name</key>
      <string>Production environment</string>
    </dict>
    <dict>
      <key>organization</key>
      <string>mycompany</string>
      <key>override_api_endpoint</key>
      <string>203.0.113.0</string>
      <key>override_doh_endpoint</key>
      <string>203.0.113.0</string>
      <key>override_warp_endpoint</key>
      <string>203.0.113.0:0</string>
      <key>display_name</key>
      <string>China employees</string>
    </dict>
    <dict>
      <key>organization</key>
      <string>test-org</string>
      <key>display_name</key>
      <string>Test environment</string>
    </dict>
  </array>
</dict>
```

### plist

[Download](https://developers.cloudflare.com/cloudflare-one/static/mdm/multiple-orgs/com.cloudflare.warp.plist) an example `.plist` file.

### mobileconfig

[Download](https://developers.cloudflare.com/cloudflare-one/static/mdm/multiple-orgs/CloudflareWARP.mobileconfig) an example `.mobileconfig` file.

## Switch organizations in WARP

* Windows, macOS, and Linux

  To switch to a different organization as a user:

  1. Open the WARP client on your device.

  2. Select the gear icon.

  3. Select **Switch configurations**. The menu will show the organizations that the admin has configured for your device.

  4. Select the organization that you want to connect to.

  5. If prompted, complete the authentication steps required for the new organization. Your authentication information will be saved and you will be able to switch back and forth between organizations.

  Note

  Only admins can [add additional organizations](#mdm-file-format) to the WARP GUI. To connect to an organization that is not displayed in the GUI, go to **Preferences > Account** to manually log out of the old organization and log into the new organization.

* iOS and Android

  To switch to a different organization as a user:

  1. Open the WARP client on your device.

  2. Go to Settings > Advanced.

  3. Select **Switch configurations**. The menu will show the organizations that the admin has configured for your device.

  4. Select the organization that you want to connect to.

  5. If prompted, complete the authentication steps required for the new organization. Your authentication information will be saved and you will be able to switch back and forth between organizations.

  Note

  Only admins can [add additional organizations](#mdm-file-format) to the WARP GUI. To connect to an organization that is not displayed in the GUI, go to **Settings > Account** to manually log out of the old organization and log into the new organization.

### Troubleshooting

When switching organizations or connecting for the first time, keep the following in mind:

* If this is the first time connecting to an organization, web browsers like Chrome may require a full restart to correctly recognize and trust the organization's root certificate. Cloudflare recommends closing all browser windows after the initial connection. All subsequent switches should not require a restart.
* On macOS, ensure the specific CA certificate for the new organization is properly trusted by verifying its status in Keychain Access.
* Switching configurations may sometimes momentarily disconnect the WARP client. If this occurs, simply re-enable WARP to restore the connection.
