---
title: Custom rules · Cloudflare Learning Paths
description: Custom rules allow you to control incoming traffic by filtering
  requests to a zone. They work as customized web application firewall (WAF)
  rules that you can use to perform actions like Block or Managed Challenge on
  incoming requests. You can also use the Skip action in a custom rule to skip
  one or more Cloudflare security features.
lastUpdated: 2024-10-25T11:11:03.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/application-security/firewall/custom-rules/
  md: https://developers.cloudflare.com/learning-paths/application-security/firewall/custom-rules/index.md
---

Custom rules allow you to control incoming traffic by filtering requests to a zone. They work as customized web application firewall (WAF) rules that you can use to perform actions like *Block* or *Managed Challenge* on incoming requests. You can also use the *Skip* action in a custom rule to [skip one or more Cloudflare security features](https://developers.cloudflare.com/waf/custom-rules/skip/).

In the [new security dashboard](https://developers.cloudflare.com/security/), custom rules are one of the available types of [security rules](https://developers.cloudflare.com/security/rules/). Security rules perform security-related actions on incoming requests that match specified filters.

Like other rules evaluated by Cloudflare's [Ruleset Engine](https://developers.cloudflare.com/ruleset-engine/), custom rules have the following basic parameters:

* An [expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/) that specifies the criteria you are matching traffic on using the [Rules language](https://developers.cloudflare.com/ruleset-engine/rules-language/).
* An [action](https://developers.cloudflare.com/ruleset-engine/rules-language/actions/) that specifies what to perform when there is a match for the rule.

The [custom rules documentation](https://developers.cloudflare.com/waf/custom-rules/) includes examples for common use cases.

## Skip rules

You can skip one or more Cloudflare security features using a custom rule [configured with the *Skip* action](https://developers.cloudflare.com/waf/custom-rules/skip/). These rules are also known as skip rules. Refer to [Skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/) for more information on the features you can skip.
