---
title: Overview · Cloudflare Network Error Logging docs
description: Network Error Logging (NEL) is a browser-based reporting system
  that allows users to report their own failures to an external endpoint. You
  can use Network Error Logging to gain insight into connectivity issues on the
  Internet to learn when and where an incident is happening, who is impacted,
  and how they are being impacted.
lastUpdated: 2025-06-17T16:28:37.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network-error-logging/
  md: https://developers.cloudflare.com/network-error-logging/index.md
---

Network Error Logging (NEL) is a browser-based reporting system that allows users to report their own failures to an external endpoint. You can use Network Error Logging to gain insight into connectivity issues on the Internet to learn when and where an incident is happening, who is impacted, and how they are being impacted.

## The last mile

The last mile is the path from a user to the first point of ingress to the resource, whether that be a network like Cloudflare or directly to the origin server. The last mile is important because it is in the critical path of the request for a resource: if the last mile has issues, users cannot connect to their resources. When Network Error Logging is enabled, you can receive alerts about issues in the last mile — which are typically difficult to detect — to learn what the problem is and how to fix it.

![The last mile diagram, showing the steps involved in delivering data to a customer](https://developers.cloudflare.com/_astro/last-mile.oZJOfPRC_Zs7vUh.webp)

## How NEL affects requests

The Report-To header is present in all requests to Cloudflare zones that have NEL enabled:  

```txt
report-to: {"group":"cf-nel","max_age":31536000,"endpoints":[{"url":"`[`https://a.nel.cloudflare.com/report?lkg-colo=lhr&lkg-time=1600338181`](https://gcp.nel.cloudflare.com/report?lkg-colo=lhr&lkg-time=1600338181&lkg-ip=1.1.1.1)`"}]}
```

A sample Network Error Report payload appears as follows:

```json
{
  "age": 20,
  "type": "network-error",
  "url": "https://example.com/previous-page",
  "body": {
    "elapsed_time": 18,
    "method": "POST",
    "phase": "dns",
    "protocol": "http/1.1",
    "referrer": "https://example.com/previous-page",
    "sampling_fraction": 1,
    "server_ip": "",
    "status_code": 0,
    "type": "dns.name_not_resolved",
    "url": "https://example-host.com/"
  }
}
```

## Privacy

Cloudflare uses geolocation lookups to extract the following information from every client IP in a NEL report:

* Client ASN
* Client country
* Client metro area

Cloudflare uses internal lookups to associate the above data with a customer domain and customer account.

Cloudflare does not store any PII or user-specific data, and any IP data is only kept for the duration of the request as it is processed. After the report is processed through the NEL pipeline, all PII data is purged from the system.

The client IP address is only stored in volatile memory for the lifetime of the request to Cloudflare’s NEL endpoint (order of milliseconds) and is dropped immediately after the request completes. Cloudflare does not log the client IP address anywhere in the Network Error Logging pipeline. Customers can opt out of having their end users consume the NEL headers by [contacting Cloudflare support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).
