---
title: Overview · Cloudflare Security Center docs
description: "Cloudflare Security Center brings together our suite of security
  products, our security expertise, and unique Internet intelligence as a
  unified security intelligence solution. Security Center enables you to
  strengthen your security posture by:"
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/security-center/
  md: https://developers.cloudflare.com/security-center/index.md
---

Cloudflare Security Center brings together our suite of security products, our security expertise, and unique Internet intelligence as a unified security intelligence solution. Security Center enables you to strengthen your security posture by:

* Mapping your cyber attack surface
* Providing asset inventory and discovery
* Identifying potential security risks, misconfigurations, and vulnerabilities
* Helping you to mitigate these risks through remediation in a few clicks

## Main features

* **Security Insights**: Review and manage potential security risks and vulnerabilities associated with your IT infrastructure.
* **Infrastructure**: Review and manage your IT infrastructure.
* **Investigate**: Investigate threats using data from Cloudflare's global network.
* **Security Reports (beta)**: Gain visibility into requests blocked or challenged by the Cloudflare Application Security suite of products.
* **Brand Protection (beta)**: Search for new domains that may be attempting to impersonate your brand.

[Get started](https://developers.cloudflare.com/security-center/get-started/)

***

## Availability

Cloudflare Security Center is available to customers on all plans. If you have any comments, questions, or bugs to report, create a post in the [Cloudflare Community forum](https://community.cloudflare.com/c/security/security-center/65).

The frequency of security scans depends on your Cloudflare plan. Refer to [Scan frequency](https://developers.cloudflare.com/security-center/security-insights/how-it-works/#scan-frequency) for more information.

## Limitations

* Users with an [Administrator Read Only](https://developers.cloudflare.com/fundamentals/manage-members/roles/#account-scoped-roles) role cannot access the Cloudflare Security Center.
* Only Cloudflare accounts with at least one Business or Enterprise zone, or accounts on the Teams Standard or Teams Enterprise plans, can manually start a new scan.
