---
title: Product descriptions · Cloudflare Style Guide
description: Statements about the product and its benefits for customers.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/product-descriptions/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/product-descriptions/index.md
---

## Definition

Statements about the product and its benefits for customers.

## Used in

[Overview (or Landing Page)](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/overview/), Support home page, Cloudflare Docs home page

## Structure

There are two product descriptions: short and long. Both descriptions are used in the Overview (or Landing page) as part of an introduction to the product.

### Short description

The short description should be a short summary statement about the product. This does not need to be, and ideally should not be, a complete sentence.

**Example**

Cloudflare Registrar: Cloudflare's domain registrar

### Long description

A long product description should summarize the product and the value or benefits it brings customers. It is comprised of two main assertions: 1) what the product does, and 2) how this benefits the customer. This description is used in the [Overview (or Landing page)](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/overview/) as an introduction to the product.

**Intent**: To show what a customer could use this product for. It should not be trying to sell like marketing content, but you can refer to marketing statements as they give good summaries and descriptions. Often times, you can use a the same or similar and change the tone to be more product appropriate.

**Length**: 2-4 sentences (keep sentences readable - 7th grade reading level rule)

**Example**

Cloudflare Registrar: Manage your domain with Cloudflare Registrar and add an additional layer of security to your DNS records for free.
