---
title: Issues sharing to Facebook · Cloudflare Web Application Firewall (WAF) docs
description: "Cloudflare does not block or challenge requests from Facebook by
  default. However, a post of a website to Facebook returns an Attention
  Required error in the following situations:"
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/troubleshooting/facebook-sharing/
  md: https://developers.cloudflare.com/waf/troubleshooting/facebook-sharing/index.md
---

Cloudflare does not block or challenge requests from Facebook by default. However, a post of a website to Facebook returns an *Attention Required* error in the following situations:

* You have globally [enabled Under Attack mode](https://developers.cloudflare.com/fundamentals/reference/under-attack-mode/).
* There is a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/) or [page rule](https://developers.cloudflare.com/rules/page-rules/) setting turning on Under Attack mode.
* There is a [custom rule](https://developers.cloudflare.com/waf/custom-rules/) with a challenge or block action that includes a Facebook IP address.

A country challenge can block a Facebook IP address. Facebook is known to crawl from both the US and Ireland.

## Resolution

To resolve issues sharing to Facebook, do one of the following:

* Remove the corresponding IP, ASN, or country custom rule that challenges or blocks Facebook IPs.
* Create a [skip rule](https://developers.cloudflare.com/waf/custom-rules/skip/) for ASNs `AS32934` and `AS63293` (use the *Skip* action and configure the rule to skip **Security Level**).
* Review existing configuration rules and Page Rules and make sure they are not affecting requests from Facebook IPs.

If you experience issues with Facebook sharing, you can re-scrape pages via the **Fetch New Scrape Information** option on Facebook's Object Debugger. Facebook [provides an API](https://developers.facebook.com/docs/sharing/opengraph/using-objects) to help update a large number of resources.

If you continue to have issues, you can [contact Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) with the URLs of your website that cannot share to Facebook, and confirming that you have re-scraped the URLs.
